/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>     // Includes most Origin header files
#include <String.h>     // String class
#include <Dialog.h>     // Dialog class
#include "Slider.h"		// Resources in Slider.DLL

class CSliderSetVol : public Dialog
{
public:
	CSliderSetVol(): Dialog(IDD_SETVOL_SET_VOLUME, "Slider")
	{
		
	}
	
	virtual int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);  //Launch the dialog
		return nRet;
	}	
	
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_OK( OnOK )
	ON_SLIDE_BEFORE( IDC_SETVOL_VOLUME_SLIDER, OnSlide )
	ON_WM_VSCROLL_BEFORE( IDC_SETVOL_VERTICAL_SLIDER, OnVerticalSlide )
EVENTS_END
	
	// Event handler to initialize Dialog
	BOOL OnInitDialog()
	{
		string str;
	
		m_iCurrentVolumeSetting = 6;	
		
		// Make all interface controls as data member, and initialize them here
		m_sldrVolumeSlider = GetItem( IDC_SETVOL_VOLUME_SLIDER );
		m_sldrVerticalSlider = GetItem( IDC_SETVOL_VERTICAL_SLIDER );
		m_cntrlVolumeStatic = GetItem( IDC_SETVOL_VOLUME_STATIC );
	
		// Access controls on Dialog
		m_sldrVolumeSlider.RangeMin = 0;
		m_sldrVolumeSlider.RangeMax = 11;
		m_sldrVolumeSlider.SetTicFreq(1);
		m_sldrVolumeSlider.Position = m_iCurrentVolumeSetting;
		
		m_sldrVerticalSlider.SetTicFreq(10);
		
		str.Format( "Volume: %d", m_iCurrentVolumeSetting ); 
		m_cntrlVolumeStatic.Text = str;
	
		return TRUE;
	}
	
	// OK button click event handler
	BOOL OnOK()
	{
		out_int("SetVolume has final value of ", m_iCurrentVolumeSetting);
		return TRUE;
	}
	
	// OnSlide event handler
	BOOL OnSlide( Control ctrl, UINT nCode, UINT nPos )
	{
		string str;
	
		Slider sldrVolumeSlider( ctrl ); // Use passed Control argument to attach to Slider control	
		
		m_iCurrentVolumeSetting = sldrVolumeSlider.Position;
	
		str.Format( "Volume: %d", m_iCurrentVolumeSetting ); 
		m_cntrlVolumeStatic.Text = str;
	
		return TRUE;
	}
	
	// OnVerticalSlide event handler
	BOOL OnVerticalSlide( Control ctrl, UINT nCode, UINT nPos )
	{
		return OnSlide(  ctrl, nCode, nPos );
	}
	
	
private:
	int m_iCurrentVolumeSetting;	
	
	Slider	m_sldrVolumeSlider;
	Slider  m_sldrVerticalSlider;
	Control m_cntrlVolumeStatic;

};